<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Candidate;
use App\Models\House;
use App\Models\Vote;

class VoteController extends Controller
{
    // 1. Ambil Data Awal (Kandidat & List Rumah)
    public function index()
    {
        return response()->json([
            'candidates' => Candidate::all(),
            // Kita kirim data rumah: ID, Blok, Nomor, dan Nama Pemilik (agar mudah dicari)
            'houses' => House::select('id', 'block', 'number', 'owner_name')->get()
        ]);
    }

    // 2. Proses Simpan Suara (VOTE)
    public function store(Request $request)
    {
        // Validasi Input
        $request->validate([
            'voter_name' => 'required|string',
            'house_id' => 'required|exists:houses,id',
            'candidate_id' => 'required|exists:candidates,id',
        ]);

        // LOGIKA UTAMA: Cek Kuota Rumah (Max 2 Suara)
        $currentVotes = Vote::where('house_id', $request->house_id)->count();

        if ($currentVotes >= 2) {
            // Ambil info rumah untuk pesan error yang sopan
            $house = House::find($request->house_id);
            return response()->json([
                'message' => "Mohon maaf, jatah suara untuk rumah Bpk/Ibu {$house->owner_name} (Blok {$house->block} No. {$house->number}) sudah habis (Maksimal 2 orang)."
            ], 403); // 403 Forbidden
        }

        // Simpan Vote
        Vote::create([
            'voter_name' => $request->voter_name,
            'house_id' => $request->house_id,
            'candidate_id' => $request->candidate_id,
            'voted_at' => now(),
        ]);

        return response()->json(['message' => 'Terima kasih, suara Anda telah direkam!']);
    }
    public function liveStats()
    {
        // Hanya kirim data yang diperlukan untuk grafik
        $candidates = \App\Models\Candidate::withCount('votes')->get();
        
        return response()->json([
            'labels' => $candidates->pluck('name'),
            'data' => $candidates->pluck('votes_count'),
            'total' => \App\Models\Vote::count()
        ]);
    }
}