<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Vote extends Model
{
    use HasFactory;

    // Matikan timestamps default (created_at/updated_at) karena kita pakai 'voted_at' manual
    public $timestamps = false; 

    protected $fillable = ['voter_name', 'house_id', 'candidate_id', 'voted_at'];

    // Agar kita bisa tahu siapa pemilik rumah dari data vote
    public function house()
    {
        return $this->belongsTo(House::class);
    }

    public function candidate()
    {
        return $this->belongsTo(Candidate::class);
    }
}