<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema; // <--- PENTING: Tambah baris ini

class HouseSeeder extends Seeder
{
    public function run()
    {
        // 1. Matikan perlindungan Foreign Key sebentar
        Schema::disableForeignKeyConstraints();

        // 2. Kosongkan tabel (Sekarang sudah bisa)
        DB::table('houses')->truncate();

        // 3. Nyalakan lagi perlindungannya
        Schema::enableForeignKeyConstraints();

        $warga = [
            ["blok" => "Norri", "no" => "4", "kk" => "Irwan Hermawan"],
            ["blok" => "Norri", "no" => "5", "kk" => "Ari"],
            ["blok" => "Norri", "no" => "6", "kk" => "Nurwenda Budiana"],
            ["blok" => "Norri", "no" => "7", "kk" => "Abduk Kholiq"],
            ["blok" => "Norri", "no" => "9", "kk" => "Salim (Bintang)"],
            ["blok" => "Norri", "no" => "10", "kk" => "Eva"],
            ["blok" => "Norri", "no" => "11", "kk" => "Anne Ratna Komalasari"],
            ["blok" => "Norri", "no" => "12", "kk" => "Edi Rustandi"],
            ["blok" => "Norri", "no" => "14", "kk" => "Pepen Supendi"],
            ["blok" => "Norri", "no" => "15", "kk" => "Basuki"],
            ["blok" => "Norri", "no" => "16", "kk" => "Riki Kurnia"],
            ["blok" => "C2", "no" => "1", "kk" => "Muh. Iman"],
            ["blok" => "C2", "no" => "2", "kk" => "Cepi"],
            ["blok" => "C2", "no" => "3", "kk" => "Susan"],
            ["blok" => "C3", "no" => "1", "kk" => "Ade Nugraha"],
            ["blok" => "C3", "no" => "2", "kk" => "Buddy"],
            ["blok" => "C3", "no" => "3", "kk" => "Yoga"],
            ["blok" => "C3", "no" => "4", "kk" => "Lucky mardiana"],
            ["blok" => "C3", "no" => "5", "kk" => "Damri Fuad"],
            ["blok" => "C3", "no" => "6", "kk" => "Slamet Bejo"],
            ["blok" => "C3", "no" => "7", "kk" => "Ahmad Al mumtaz"],
            ["blok" => "C3", "no" => "8", "kk" => "Iman Nurjaman"],
            ["blok" => "C3", "no" => "9", "kk" => "Meidio Langkay"],
            ["blok" => "C3", "no" => "10", "kk" => "Miftah Fauzi"],
            ["blok" => "C3", "no" => "11", "kk" => "Tarsono"],
            ["blok" => "C3", "no" => "12", "kk" => "Ridwan M Nurdin"],
            ["blok" => "C3", "no" => "13", "kk" => "Asep Adi Suprajat"],
            ["blok" => "C3", "no" => "14", "kk" => "Wahyu Setiawan"],
            ["blok" => "C3", "no" => "15", "kk" => "Reviyanti"],
            ["blok" => "C3", "no" => "16", "kk" => "Acep Yayan Taryana"],
            ["blok" => "C3", "no" => "17", "kk" => "Kadarusman"],
            ["blok" => "C3", "no" => "19", "kk" => "Agus"],
            ["blok" => "C3", "no" => "21", "kk" => "Hendra Hendrito"],
            ["blok" => "C3", "no" => "22", "kk" => "Agung Gumelar"],
            ["blok" => "C3", "no" => "23", "kk" => "Supriyadi"],
            ["blok" => "C3", "no" => "24", "kk" => "Faza"],
            ["blok" => "C3", "no" => "25", "kk" => "Ikhsan"],
            ["blok" => "C3", "no" => "28", "kk" => "Cema"],
            ["blok" => "C3", "no" => "29", "kk" => "Agus Suryana"],
            ["blok" => "C3", "no" => "32", "kk" => "Nova"],
            ["blok" => "C3", "no" => "33", "kk" => "Nana Rukmana"],
            ["blok" => "C3", "no" => "34", "kk" => "Sofyan"],
            ["blok" => "C4", "no" => "1", "kk" => "Egi"],
            ["blok" => "C4", "no" => "2", "kk" => "Sopian"],
            ["blok" => "C4", "no" => "3", "kk" => "Gandi Sopian"],
            ["blok" => "C4", "no" => "4", "kk" => "Muh. Fathir"],
            ["blok" => "C4", "no" => "13", "kk" => "Ridwan Fauzi"],
            ["blok" => "C4", "no" => "15", "kk" => "Saepul Anwar"],
            ["blok" => "C4", "no" => "16", "kk" => "Heri"],
            ["blok" => "C5", "no" => "1", "kk" => "Adi Rinaldi"],
            ["blok" => "C5", "no" => "4", "kk" => "Aditya Nugraha"],
            ["blok" => "C5", "no" => "5", "kk" => "Harista Wanda Setiawan"],
            ["blok" => "C5", "no" => "6", "kk" => "Budi Setiadi"],
            ["blok" => "C5", "no" => "7", "kk" => "Agus Basuki"],
            ["blok" => "C5", "no" => "8", "kk" => "Aiko"],
            ["blok" => "C5", "no" => "9", "kk" => "Pane"],
            ["blok" => "C5", "no" => "10", "kk" => "Andri"],
            ["blok" => "C5", "no" => "11", "kk" => "Ridwan Sihabudin"],
            ["blok" => "C5", "no" => "12", "kk" => "Praja"],
            ["blok" => "C5", "no" => "13", "kk" => "Samudra Harefa"],
            ["blok" => "C5", "no" => "14", "kk" => "Feby"],
            ["blok" => "C5", "no" => "15", "kk" => "Muh Sidiq"],
            ["blok" => "C5", "no" => "17", "kk" => "Gunawan Setiaji"],
            ["blok" => "C5", "no" => "18", "kk" => "Yusuf Nour"],
            ["blok" => "C5", "no" => "19", "kk" => "Risyad"],
            ["blok" => "C5", "no" => "21", "kk" => "Alif"],
            ["blok" => "C5", "no" => "21A", "kk" => "Bugi"],
            ["blok" => "C5", "no" => "22", "kk" => "Ujang"],
            ["blok" => "C5", "no" => "23", "kk" => "Wahyu"],
            ["blok" => "C5", "no" => "24", "kk" => "Acep Sopian Soleh"],
            ["blok" => "C5", "no" => "26", "kk" => "Adam"],
            ["blok" => "C5", "no" => "27", "kk" => "Shodiq"],
            ["blok" => "C5", "no" => "28", "kk" => "Nori"],
            ["blok" => "C5", "no" => "29", "kk" => "Sutisna"],
            ["blok" => "C5", "no" => "30", "kk" => "M. Septian Saputra"],
            ["blok" => "C5", "no" => "31", "kk" => "Prasetio Handono Budi"],
            ["blok" => "C5", "no" => "32", "kk" => "Iqmal"],
            ["blok" => "C5", "no" => "33", "kk" => "Dinda"],
            ["blok" => "C5", "no" => "34", "kk" => "Dicky Maulana Septiadi"],
            ["blok" => "C5", "no" => "35", "kk" => "Enrico K"],
            ["blok" => "C5", "no" => "36", "kk" => "Aif"],
            ["blok" => "C5", "no" => "38A", "kk" => "Rivaldi Prayoga Prawira"],
            ["blok" => "C5", "no" => "38B", "kk" => "Deli Roswandi"],
            ["blok" => "C6", "no" => "1", "kk" => "Ari Febrianto"],
            ["blok" => "C6", "no" => "2", "kk" => "Ahmad Nazib"],
            ["blok" => "C6", "no" => "4", "kk" => "Rauza Syakir"],
            ["blok" => "C6", "no" => "5", "kk" => "Firdhan Vandaru"],
            ["blok" => "C6", "no" => "6", "kk" => "Rizki"],
            ["blok" => "C6", "no" => "7", "kk" => "Rizal Febriana"],
            ["blok" => "C7", "no" => "1", "kk" => "Wawan Kurniawan"],
            ["blok" => "C7", "no" => "4", "kk" => "Andre"],
            ["blok" => "C7", "no" => "5", "kk" => "Gusrian"],
            ["blok" => "C7", "no" => "6", "kk" => "Akbar"],
            ["blok" => "C7", "no" => "7", "kk" => "Dede Tarsudjo"],
            ["blok" => "C7", "no" => "8", "kk" => "Risty"],
            ["blok" => "C7", "no" => "9", "kk" => "Aldi Rachman"],
            ["blok" => "C7", "no" => "10", "kk" => "Adjie"],
            ["blok" => "C7", "no" => "11", "kk" => "Endang Suryana"],
            ["blok" => "C7", "no" => "12", "kk" => "Ali"],
            ["blok" => "C7", "no" => "13", "kk" => "M. Fadhil Rahmansyah"],
            ["blok" => "C7", "no" => "15", "kk" => "I Komang Sudana"],
            ["blok" => "C7", "no" => "16", "kk" => "Fakhriaji"],
            ["blok" => "C7", "no" => "19", "kk" => "Rini"],
            ["blok" => "C7", "no" => "20A", "kk" => "Herry"],
            ["blok" => "C7", "no" => "20B", "kk" => "Yadi"],
            ["blok" => "C7", "no" => "21", "kk" => "Fikri Triyantoro"],
            ["blok" => "C7", "no" => "21A", "kk" => "Faisal"],
            ["blok" => "C7", "no" => "21B", "kk" => "Boby"],
            ["blok" => "C8", "no" => "01", "kk" => "Deden"]
        ];

        foreach ($warga as $item) {
            DB::table('houses')->insert([
                'block' => $item['blok'],
                'number' => $item['no'],
                'owner_name' => $item['kk'],
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
    }
}