import { createRouter, createWebHistory } from 'vue-router';

// Import Halaman
import VotePage from '../pages/VotePage.vue';
import AdminLogin from '../pages/AdminLogin.vue';
import AdminDashboard from '../pages/AdminDashboard.vue';
import LiveCount from '../pages/LiveCount.vue'; // <--- BARU: Import Halaman Live

const routes = [
    // 1. Halaman Depan (Warga)
    { 
        path: '/', 
        name: 'home', 
        component: VotePage 
    },

    // 2. Halaman Live Count (Proyektor) - BARU
    { 
        path: '/live', 
        name: 'live.count', 
        component: LiveCount 
    },

    // 3. Halaman Login Admin (Pintu Gerbang)
    { 
        path: '/admin', 
        name: 'admin.login', 
        component: AdminLogin,
        // Cek: Kalau admin sudah login, langsung lempar ke dashboard
        beforeEnter: (to, from, next) => {
            if (localStorage.getItem('admin_token')) {
                next({ name: 'admin.dashboard' });
            } else {
                next();
            }
        }
    },

    // 4. Halaman Dashboard (Ruang Rahasia)
    { 
        path: '/admin/dashboard', 
        name: 'admin.dashboard', 
        component: AdminDashboard,
        // PASANG SATPAM DI SINI (Wajib Login)
        meta: { requiresAuth: true } 
    },
];

const router = createRouter({
    history: createWebHistory(),
    routes,
});

// LOGIKA SATPAM GLOBAL
router.beforeEach((to, from, next) => {
    // Cek apakah halaman tujuan butuh login?
    if (to.meta.requiresAuth) {
        const token = localStorage.getItem('admin_token');
        if (token) {
            next(); // Punya token? Silakan masuk
        } else {
            next({ name: 'admin.login' }); // Tidak punya? Tendang ke halaman Login
        }
    } else {
        next(); // Halaman umum, silakan lewat
    }
});

export default router;