<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\VoteController;
use App\Http\Controllers\AdminController;

// --- PUBLIC (WARGA & PROYEKTOR) ---
Route::get('/initial-data', [VoteController::class, 'index']);
Route::get('/live-stats', [VoteController::class, 'liveStats']); // Untuk Halaman Live Count

// ANTI SPAM: Batasi 10 vote per menit per IP
// (Pastikan rute /vote hanya ada di dalam sini, jangan duplikat di luar)
Route::middleware('throttle:10,1')->group(function () {
    Route::post('/vote', [VoteController::class, 'store']);
});

Route::post('/admin/login', [AdminController::class, 'login']);

// --- ADMIN (DASHBOARD & CRUD) ---
Route::get('/admin/dashboard', [AdminController::class, 'dashboard']);
Route::get('/admin/export', [AdminController::class, 'exportCsv']); // <--- BARU: Export Excel
Route::post('/admin/reset', [AdminController::class, 'resetData']);

// Manajemen Kandidat
Route::post('/candidates', [AdminController::class, 'storeCandidate']);      
Route::post('/candidates/{id}', [AdminController::class, 'updateCandidate']); 
Route::delete('/candidates/{id}', [AdminController::class, 'deleteCandidate']); 

// Hapus Data (Logs)
Route::delete('/votes/{id}', [AdminController::class, 'deleteVote']); 
Route::delete('/admin-logs/{id}', [AdminController::class, 'deleteAdminLog']);