<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
{
    Schema::create('votes', function (Blueprint $table) {
        $table->id();
        $table->string('voter_name'); // Nama pengisi suara (Suami/Istri)

        // Relasi ke Rumah (Kunci Validasi 2 Suara)
        $table->foreignId('house_id')->constrained('houses')->onDelete('cascade');

        // Relasi ke Kandidat
        $table->foreignId('candidate_id')->constrained('candidates');

        $table->timestamp('voted_at'); // Waktu memilih
    });
}

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('votes');
    }
};
