<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\House;
use App\Models\Candidate;

class DatabaseSeeder extends Seeder
{
    public function run(): void
    {
        // 1. Masukkan Data Warga (Sesuai List Anda)
        $houses = [
            ['block' => 'Norri', 'number' => '4', 'owner_name' => 'Irwan Hermawan'],
            ['block' => 'Norri', 'number' => '5', 'owner_name' => 'Ari'],
            ['block' => 'Norri', 'number' => '6', 'owner_name' => 'Nurwenda Budyana'],
            ['block' => 'Norri', 'number' => '7', 'owner_name' => 'Abduk Kholiq'],
            ['block' => 'Norri', 'number' => '9', 'owner_name' => 'Salim (Bintang)'],
            ['block' => 'Norri', 'number' => '10', 'owner_name' => 'Eva'],
            ['block' => 'Norri', 'number' => '11', 'owner_name' => 'Anne Ratna Komalasari'],
            ['block' => 'Norri', 'number' => '12', 'owner_name' => 'Edi Rustandi'],
            ['block' => 'Norri', 'number' => '14', 'owner_name' => 'Pepen Supendi'],
            ['block' => 'Norri', 'number' => '15', 'owner_name' => 'Basuki'],
            ['block' => 'Norri', 'number' => '16', 'owner_name' => 'Riki Kurnia'],
            ['block' => 'C2', 'number' => '1', 'owner_name' => 'Muh. Iman'],
            ['block' => 'C2', 'number' => '2', 'owner_name' => 'Cepi'],
            ['block' => 'C2', 'number' => '3', 'owner_name' => 'Susan'],
            ['block' => 'C3', 'number' => '1', 'owner_name' => 'Ade Nugraha'],
            ['block' => 'C3', 'number' => '2', 'owner_name' => 'Buddy'],
            ['block' => 'C3', 'number' => '3', 'owner_name' => 'Yoga'],
            ['block' => 'C3', 'number' => '4', 'owner_name' => 'Lucky mardiana'],
            ['block' => 'C3', 'number' => '5', 'owner_name' => 'Damri Fuad'],
            ['block' => 'C3', 'number' => '6', 'owner_name' => 'Slamet Bejo'],
            ['block' => 'C3', 'number' => '7', 'owner_name' => 'Ahmad Al mumtaz'],
            ['block' => 'C3', 'number' => '8', 'owner_name' => 'Iman Nurjaman'],
            ['block' => 'C3', 'number' => '9', 'owner_name' => 'Meidio Langkay'],
            ['block' => 'C3', 'number' => '10', 'owner_name' => 'Miftah Fauzi'],
            ['block' => 'C3', 'number' => '11', 'owner_name' => 'Tarsono'],
            ['block' => 'C3', 'number' => '12', 'owner_name' => 'Ridwan M Nurdin'],
            ['block' => 'C3', 'number' => '13', 'owner_name' => 'Asep Adi Suprajat'],
            ['block' => 'C3', 'number' => '14', 'owner_name' => 'Wahyu Setiawan'],
            ['block' => 'C3', 'number' => '15', 'owner_name' => 'Reviyanti'],
            ['block' => 'C3', 'number' => '16', 'owner_name' => 'Acep Yayan Taryana'],
            ['block' => 'C3', 'number' => '17', 'owner_name' => 'Kadarusman'],
            ['block' => 'C3', 'number' => '19', 'owner_name' => 'Agus'],
            ['block' => 'C3', 'number' => '21', 'owner_name' => 'Hendra Hendrito'],
            ['block' => 'C3', 'number' => '22', 'owner_name' => 'Agung Gumelar'],
            ['block' => 'C3', 'number' => '23', 'owner_name' => 'Supriyadi'],
            ['block' => 'C3', 'number' => '24', 'owner_name' => 'Faza'],
            ['block' => 'C3', 'number' => '25', 'owner_name' => 'Ikhsan'],
            ['block' => 'C3', 'number' => '28', 'owner_name' => 'Cema'],
            ['block' => 'C3', 'number' => '29', 'owner_name' => 'Agus Suryana'],
            ['block' => 'C3', 'number' => '32', 'owner_name' => 'Nova'],
            ['block' => 'C3', 'number' => '33', 'owner_name' => 'Nana Rukmana'],
            ['block' => 'C3', 'number' => '34', 'owner_name' => 'Sofyan'],
            ['block' => 'C4', 'number' => '1', 'owner_name' => 'Egi'],
            ['block' => 'C4', 'number' => '2', 'owner_name' => 'Sopian'],
            ['block' => 'C4', 'number' => '3', 'owner_name' => 'Gandi Sopian'],
            ['block' => 'C4', 'number' => '4', 'owner_name' => 'Muh. Fathir'],
            ['block' => 'C4', 'number' => '13', 'owner_name' => 'Ridwan Fauzi'],
            ['block' => 'C4', 'number' => '15', 'owner_name' => 'Saepul Anwar'],
            ['block' => 'C4', 'number' => '16', 'owner_name' => 'Heri'],
            ['block' => 'C5', 'number' => '1', 'owner_name' => 'Adi Rinaldi'],
            ['block' => 'C5', 'number' => '4', 'owner_name' => 'Aditya Nugraha'],
            ['block' => 'C5', 'number' => '5', 'owner_name' => 'Harista Wanda Setiawan'],
            ['block' => 'C5', 'number' => '6', 'owner_name' => 'Budi Setiadi'],
            ['block' => 'C5', 'number' => '7', 'owner_name' => 'Agus Basuki'],
            ['block' => 'C5', 'number' => '8', 'owner_name' => 'Aiko'],
            ['block' => 'C5', 'number' => '9', 'owner_name' => 'Pane'],
            ['block' => 'C5', 'number' => '10', 'owner_name' => 'Andri'],
            ['block' => 'C5', 'number' => '11', 'owner_name' => 'Ridwan Sihabudin'],
            ['block' => 'C5', 'number' => '12', 'owner_name' => 'Praja'],
            ['block' => 'C5', 'number' => '13', 'owner_name' => 'Samudra Harefa'],
            ['block' => 'C5', 'number' => '14', 'owner_name' => 'Feby'],
            ['block' => 'C5', 'number' => '15', 'owner_name' => 'Muh Sidiq'],
            ['block' => 'C5', 'number' => '17', 'owner_name' => 'Gunawan Setiaji'],
            ['block' => 'C5', 'number' => '18', 'owner_name' => 'Yusuf Nour'],
            ['block' => 'C5', 'number' => '19', 'owner_name' => 'Risyad'],
            ['block' => 'C5', 'number' => '21', 'owner_name' => 'Alif'],
            ['block' => 'C5', 'number' => '21A', 'owner_name' => 'Bugi'],
            ['block' => 'C5', 'number' => '22', 'owner_name' => 'Ujang'],
            ['block' => 'C5', 'number' => '23', 'owner_name' => 'Wahyu'],
            ['block' => 'C5', 'number' => '24', 'owner_name' => 'Acep Sopian Soleh'],
            ['block' => 'C5', 'number' => '26', 'owner_name' => 'Adam'],
            ['block' => 'C5', 'number' => '27', 'owner_name' => 'Shodiq'],
            ['block' => 'C5', 'number' => '28', 'owner_name' => 'Nori'],
            ['block' => 'C5', 'number' => '29', 'owner_name' => 'Sutisna'],
            ['block' => 'C5', 'number' => '30', 'owner_name' => 'M. Septian Saputra'],
            ['block' => 'C5', 'number' => '31', 'owner_name' => 'Prasetio Handono Budi'],
            ['block' => 'C5', 'number' => '32', 'owner_name' => 'Iqmal'],
            ['block' => 'C5', 'number' => '33', 'owner_name' => 'Dinda'],
            ['block' => 'C5', 'number' => '34', 'owner_name' => 'Dicky Maulana Septiadi'],
            ['block' => 'C5', 'number' => '35', 'owner_name' => 'Enrico K'],
            ['block' => 'C5', 'number' => '36', 'owner_name' => 'Aif'],
            ['block' => 'C5', 'number' => '38A', 'owner_name' => 'Rivaldi Prayoga Prawira'],
            ['block' => 'C5', 'number' => '38B', 'owner_name' => 'Deli Roswandi'],
            ['block' => 'C6', 'number' => '1', 'owner_name' => 'Ari Febrianto'],
            ['block' => 'C6', 'number' => '2', 'owner_name' => 'Ahmad Nazib'],
            ['block' => 'C6', 'number' => '4', 'owner_name' => 'Rauza Syakir'],
            ['block' => 'C6', 'number' => '5', 'owner_name' => 'Firdhan Vandaru'],
            ['block' => 'C6', 'number' => '6', 'owner_name' => 'Rizki'],
            ['block' => 'C6', 'number' => '7', 'owner_name' => 'Rizal Febriana'],
            ['block' => 'C7', 'number' => '1', 'owner_name' => 'Wawan Kurniawan'],
            ['block' => 'C7', 'number' => '4', 'owner_name' => 'Andre'],
            ['block' => 'C7', 'number' => '5', 'owner_name' => 'Gusrian'],
            ['block' => 'C7', 'number' => '6', 'owner_name' => 'Akbar'],
            ['block' => 'C7', 'number' => '7', 'owner_name' => 'Dede Tarsudjo'],
            ['block' => 'C7', 'number' => '8', 'owner_name' => 'Risty'],
            ['block' => 'C7', 'number' => '9', 'owner_name' => 'Aldi Rachman'],
            ['block' => 'C7', 'number' => '10', 'owner_name' => 'Adjie'],
            ['block' => 'C7', 'number' => '11', 'owner_name' => 'Endang Suryana'],
            ['block' => 'C7', 'number' => '12', 'owner_name' => 'Ali'],
            ['block' => 'C7', 'number' => '13', 'owner_name' => 'M. Fadhil Rahmansyah'],
            ['block' => 'C7', 'number' => '15', 'owner_name' => 'I Komang Sudana'],
            ['block' => 'C7', 'number' => '16', 'owner_name' => 'Fakhriaji'],
            ['block' => 'C7', 'number' => '19', 'owner_name' => 'Rini'],
            ['block' => 'C7', 'number' => '20A', 'owner_name' => 'Herry'],
            ['block' => 'C7', 'number' => '20B', 'owner_name' => 'Yadi'],
            ['block' => 'C7', 'number' => '21', 'owner_name' => 'Fikri Triyantoro'],
            ['block' => 'C7', 'number' => '21A', 'owner_name' => 'Faisal'],
            ['block' => 'C7', 'number' => '21B', 'owner_name' => 'Boby'],
            ['block' => 'C8', 'number' => '01', 'owner_name' => 'Deden'],
        ];

        foreach ($houses as $house) {
            House::create($house);
        }

        // 2. Data Dummy Kandidat (Bisa diedit nanti di Admin)
        Candidate::create([
            'name' => 'Bpk. Calon Satu',
            'visi_misi' => 'Mewujudkan Nuansa Manisi yang harmonis.',
            'photo_url' => null
        ]);
        Candidate::create([
            'name' => 'Bpk. Calon Dua',
            'visi_misi' => 'Transparan, Jujur, dan Amanah.',
            'photo_url' => null
        ]);
    }
}